package cx.threeg.dcms.ui;

import android.os.AsyncTask;
import android.os.Bundle;
import android.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.List;

import cx.threeg.dcms.R;
import cx.threeg.dcms.core.HttpClient;
import cx.threeg.dcms.core.HtmlLightParser;
import cx.threeg.dcms.core.JsoupBridge;
import cx.threeg.dcms.core.Prefs;
import cx.threeg.dcms.ui.widget.LinkAdapter;

public class HomeFragment extends Fragment {

    private EditText urlInput;
    private GridView grid;
    private LinkAdapter adapter;
    private String[] keywords;
    private boolean preferJsoup;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.fragment_home, container, false);
        urlInput = (EditText) v.findViewById(R.id.urlInput);
        Button openBtn = (Button) v.findViewById(R.id.openBtn);
        grid = (GridView) v.findViewById(R.id.grid);

        adapter = new LinkAdapter(getActivity(), new ArrayList<HtmlLightParser.LinkItem>());
        grid.setAdapter(adapter);

        keywords = Prefs.getKeywords(getActivity());
        preferJsoup = Prefs.preferJsoup(getActivity());

        urlInput.setText("https://3g.cx/");
        openBtn.setOnClickListener(new View.OnClickListener() {
            @Override public void onClick(View view) {
                load(urlInput.getText().toString());
            }
        });

        load(urlInput.getText().toString());
        return v;
    }

    private void load(final String url) {
        if (TextUtils.isEmpty(url)) return;
        new AsyncTask<Void, Void, List<HtmlLightParser.LinkItem>>() {
            Exception err;
            @Override protected List<HtmlLightParser.LinkItem> doInBackground(Void... voids) {
                try {
                    String base = "https://3g.cx";
                    if (url.startsWith("http")) {
                        String tmp = url;
                        int idx = tmp.indexOf("://");
                        if (idx > 0) {
                            int slash = tmp.indexOf("/", idx+3);
                            if (slash > 0) base = tmp.substring(0, slash);
                            else base = tmp;
                        }
                    }
                    HttpClient client = new HttpClient();
                    String html = client.get(url);
                    if (preferJsoup && JsoupBridge.available()) {
                        List<HtmlLightParser.LinkItem> j = JsoupBridge.extractLinksWithJsoup(html, base, keywords);
                        if (j != null && !j.isEmpty()) return j;
                    }
                    return HtmlLightParser.extractLinks(html, base, keywords);
                } catch (Exception e) { err = e; return null; }
            }
            @Override protected void onPostExecute(List<HtmlLightParser.LinkItem> items) {
                if (err != null) {
                    Toast.makeText(getActivity(), err.getMessage(), Toast.LENGTH_LONG).show();
                    return;
                }
                adapter.setData(items);
            }
        }.execute();
    }
}
